/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.translate.impl;

import io.gitlab.jfronny.libjf.translate.impl.TranslateConfig;

public class Throttle {
    private long nextRequestTime = 0L;

    public void waitForNextRequest() {
        if (TranslateConfig.throttleMillis == 0) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime < this.nextRequestTime) {
            try {
                Thread.sleep(this.nextRequestTime - currentTime);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.nextRequestTime = System.currentTimeMillis() + (long)TranslateConfig.throttleMillis;
    }
}

